// Learn TypeScript:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    onLoad() {

        cc.game.on(cc.game.EVENT_SHOW, () => {
            console.log("Game.EVENT_SHOW");
            cc.director.resume();
            cc.game.resume();
            cc.audioEngine.resumeAll();
        });


        cc.game.on(cc.game.EVENT_HIDE, () => {
            console.log("Game.EVENT_HIDE");
            cc.director.pause();
            cc.game.pause();
            cc.audioEngine.pauseAll();
        });


        cc.game.on(cc.game.EVENT_RESTART, () => {
            console.log("Game.EVENT_RESTART");
        });
    }

    @property(cc.AudioClip)
    audioClip: cc.AudioClip = null;

    start() {

    }

    play() {
        const audioId = cc.audioEngine.playEffect(this.audioClip, false);
        console.log("audioId play");
        cc.audioEngine.setVolume(audioId, 1);
        cc.audioEngine.setEffectsVolume(1);
        cc.audioEngine.setFinishCallback(audioId, () => {
            console.log("audio play finish");
        });
    }

    // update (dt) {}
}
