# 音频恢复测试
- 播放音频并切换台切换测试

## 表现
- ios 15 等系统，切换到后台，再切换回前台，音频播放正常
- 低版本系统，切换到后台，再切换回前台，音频播放正常
- 高版本系统 iOS 17  18 切换后台，再切换回前台，音频没有恢复且点击按钮无法播放

## ios 18.4.1 表现
- ios 15 前后台切换 audioContent 为 interrupted 状态，此状态可以恢复
- ios 18.4.1 切换到后台，再切换回前台，audioContent 为 suspended 状态，此状态无法恢复，需要重建 audioContent，启用并关闭旧的
- suspended 状态下，点击按钮无法播放，且调用恢复后，状态变为 runing 但是仍无法播放，此时应当是ios系统断开了音频通道

## 解决方案
- interrupted 正常普通恢复
- suspended 重建 audioContent，启用并关闭旧的，此时点击按钮播放音频了。但是恢复逻辑是重新播放音频。
- suspended 状态下重建后，收到浏览器限制触摸事件中，播放才能播放出来。
- 解决方案：
    - 监听 audioContent 的状态，如果状态为 interrupted，则正常恢复
    - 监听 audioContent 的状态，如果状态为 suspended，则延迟一小会儿，重建音频，并已重新播放设置指定时间来模拟恢复音频。
    - 监听 audioContent 的状态，如果状态为 suspended，则提示用户触摸屏幕恢复音频播放。

## 最终总结
- ios 系统的升级伴随着越来越多的 音频播放限制
- 测试 cocos 源码 在 低一点的系统中没有问题，也就是最近高版本系统不行
- 若为 h5 项目，在端上通过 webview 运行则建议直接端上提供统一的音频接口，一劳永逸，且还能突破静音限制
- 随后 ios 系统版本在更新或又加了什么限制，也将不受影响。


