
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Test.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'd1ea53aLRNMDrA5bw+9aNYa', 'Test');
// Script/Test.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var NewClass = /** @class */ (function (_super) {
    __extends(NewClass, _super);
    function NewClass() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._resumeAttempts = 0;
        _this._maxResumeAttempts = 3;
        _this._resumeTimer = null;
        _this.audioClip = null;
        return _this;
    }
    NewClass.prototype.onLoad = function () {
        // 使用捕获阶段监听pageshow事件，确保尽早处理
        window.addEventListener('pageshow', this.onPageShow.bind(this), true);
        // 使用自定义的展示事件处理函数
        cc.game.on(cc.game.EVENT_SHOW, this.onGameShow.bind(this));
        cc.game.on(cc.game.EVENT_HIDE, this.onGameHide.bind(this));
    };
    NewClass.prototype.onPageShow = function (event) {
        console.log("pageshow事件触发", event.persisted);
        if (event.persisted && cc.sys.os === cc.sys.OS_IOS) {
            // 清除之前可能存在的定时器
            this.clearResumeTimer();
            // 重置恢复尝试次数
            this._resumeAttempts = 0;
            // 立即尝试一次恢复
            this.onResume();
            // 设置多次尝试恢复的定时器
            this.scheduleResumeAttempts();
        }
    };
    NewClass.prototype.onGameShow = function () {
        console.log("Game.EVENT_SHOW");
        if (cc.sys.os === cc.sys.OS_IOS) {
            // 清除之前可能存在的定时器
            this.clearResumeTimer();
            // 重置恢复尝试次数
            this._resumeAttempts = 0;
            // 立即尝试一次恢复
            this.onResume();
            // 设置多次尝试恢复的定时器
            this.scheduleResumeAttempts();
        }
    };
    NewClass.prototype.onGameHide = function () {
        console.log("Game.EVENT_HIDE");
        // 清除恢复定时器
        this.clearResumeTimer();
    };
    NewClass.prototype.scheduleResumeAttempts = function () {
        var _this = this;
        // 设置多次尝试，间隔递增
        this._resumeTimer = setTimeout(function () {
            _this._resumeAttempts++;
            if (_this._resumeAttempts < _this._maxResumeAttempts) {
                console.log("\u7B2C" + _this._resumeAttempts + "\u6B21\u5C1D\u8BD5\u6062\u590DAudioContext");
                _this.onResume();
                _this.scheduleResumeAttempts();
            }
        }, 300 * (this._resumeAttempts + 1)); // 300ms, 600ms, 900ms递增间隔
    };
    NewClass.prototype.clearResumeTimer = function () {
        if (this._resumeTimer) {
            clearTimeout(this._resumeTimer);
            this._resumeTimer = null;
        }
    };
    NewClass.prototype.start = function () { };
    NewClass.prototype.onDestroy = function () {
        // 清除定时器
        this.clearResumeTimer();
        // 移除事件监听
        window.removeEventListener('pageshow', this.onPageShow.bind(this), true);
        cc.game.off(cc.game.EVENT_SHOW, this.onGameShow, this);
        cc.game.off(cc.game.EVENT_HIDE, this.onGameHide, this);
    };
    NewClass.prototype.play = function () {
        var _this = this;
        // 在播放前检查AudioContext状态
        if (cc.sys.os === cc.sys.OS_IOS) {
            var globalContext = cc.sys.__audioSupport.context;
            if (globalContext &&
                (globalContext.state === 'suspended' || globalContext.state === 'interrupted')) {
                console.log("播放前恢复AudioContext");
                globalContext.resume().then(function () {
                    _this.doPlay();
                }).catch(function (err) {
                    console.error("播放前恢复AudioContext失败:", err);
                    // 尝试强制恢复
                    _this.forceResumeAudioContext();
                    setTimeout(function () { return _this.doPlay(); }, 100);
                });
            }
            else {
                this.doPlay();
            }
        }
        else {
            this.doPlay();
        }
    };
    NewClass.prototype.doPlay = function () {
        var audioId = cc.audioEngine.playEffect(this.audioClip, false);
        console.log("audioId play:", audioId);
        if (audioId) {
            cc.audioEngine.setVolume(audioId, 1);
            cc.audioEngine.setEffectsVolume(1);
            cc.audioEngine.setFinishCallback(audioId, function () {
                console.log("audio play finish");
            });
        }
        else {
            console.error("音频播放失败，无效的audioId");
        }
    };
    NewClass.prototype.onResume = function () {
        var _this = this;
        var globalContext = cc.sys.__audioSupport.context;
        if (!globalContext) {
            console.warn("找不到全局AudioContext");
            return;
        }
        console.log("当前AudioContext状态:", globalContext.state);
        if (globalContext.state === 'suspended' || globalContext.state === 'interrupted') {
            console.log("恢复全局AudioContext");
            // 尝试恢复全局AudioContext
            globalContext.resume().then(function () {
                console.log("全局AudioContext恢复成功");
                // 强制"唤醒"音频系统
                _this.forceResumeAudioContext();
                // 恢复正在播放的音频
                _this.resumePlayingAudio();
            }).catch(function (err) {
                console.error("恢复AudioContext失败:", err);
                // 尝试使用更激进的方式恢复
                _this.forceResumeAudioContext();
            });
        }
        else {
            console.log("AudioContext状态已正常:", globalContext.state);
            // 即使状态看起来正常，也进行一次音频恢复
            // 有时iOS会报告状态正常但实际上还是无法播放
            this.resumePlayingAudio();
        }
    };
    NewClass.prototype.forceResumeAudioContext = function () {
        try {
            var globalContext = cc.sys.__audioSupport.context;
            if (!globalContext)
                return;
            // 创建一个短暂的空音频来"唤醒"系统
            var testOsc_1 = globalContext.createOscillator();
            var testGain_1 = globalContext.createGain();
            testGain_1.gain.value = 0.01; // 极小音量但不是0
            testOsc_1.connect(testGain_1);
            testGain_1.connect(globalContext.destination);
            testOsc_1.start(0);
            setTimeout(function () {
                try {
                    testOsc_1.stop();
                    testOsc_1.disconnect();
                    testGain_1.disconnect();
                }
                catch (e) { }
            }, 100); // 短暂播放100ms
            console.log("强制唤醒AudioContext完成");
        }
        catch (e) {
            console.error("强制唤醒AudioContext失败:", e);
        }
    };
    NewClass.prototype.resumePlayingAudio = function () {
        // 遍历所有音频并检查它们的状态
        var audioIds = Object.keys(cc.audioEngine._id2audio);
        console.log("恢复音频状态检查, 当前音频数:", audioIds.length);
        if (audioIds.length === 0)
            return;
        // 恢复所有正在播放的音频
        for (var _i = 0, audioIds_1 = audioIds; _i < audioIds_1.length; _i++) {
            var id = audioIds_1[_i];
            var audio = cc.audioEngine._id2audio[id];
            if (!audio || !audio._element)
                continue;
            var audioState = audio._state;
            console.log("\u97F3\u9891ID: " + id + ", \u72B6\u6001: " + audioState);
            if (audioState === cc.audioEngine.AudioState.PLAYING &&
                (audio._element.paused ||
                    (audio._element._currentSource === null && audio._element._context))) {
                console.log("\u6062\u590D\u64AD\u653E\u97F3\u9891: " + id);
                try {
                    // 先确保音量正确
                    var volume = audio.getVolume();
                    audio.setVolume(volume);
                    // 然后恢复播放
                    audio.resume();
                }
                catch (e) {
                    console.error("\u6062\u590D\u97F3\u9891" + id + "\u5931\u8D25:", e);
                }
            }
        }
    };
    __decorate([
        property(cc.AudioClip)
    ], NewClass.prototype, "audioClip", void 0);
    NewClass = __decorate([
        ccclass
    ], NewClass);
    return NewClass;
}(cc.Component));
exports.default = NewClass;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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