
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Test2.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '91d14euzCdIxoRGC/Gr9swn', 'Test2');
// Script/Test2.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var AudioManager = /** @class */ (function (_super) {
    __extends(AudioManager, _super);
    function AudioManager() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.playButton = null;
        _this.audioClip = null;
        _this.isAudioSystemReset = true;
        // 保存后台前正在播放的音频信息
        _this.playingAudios = new Map();
        _this._testAudioId = -1;
        return _this;
    }
    AudioManager.prototype.onLoad = function () {
        var _this = this;
        if (cc.sys.isBrowser && cc.sys.os === cc.sys.OS_IOS) {
            cc.game.on(cc.game.EVENT_GAME_INITED, function () {
                cc.game.on(cc.game.EVENT_SHOW, _this.handleGameShow, _this);
                cc.game.on(cc.game.EVENT_HIDE, _this.handleGameHide, _this);
            });
        }
        // 设置按钮事件
        if (this.playButton) {
            this.playButton.node.on('click', this.onPlayButtonClick, this);
        }
    };
    AudioManager.prototype.handleGameShow = function () {
        var _this = this;
        console.log("应用恢复到前台");
        var state = cc.audioEngine.getState(this._testAudioId);
        console.log("\u5F53\u524D\u6D4B\u8BD5\u97F3\u9891ID=" + this._testAudioId + ", \u72B6\u6001=" + state);
        var audio = cc.audioEngine._id2audio[this._testAudioId];
        var content = cc.sys.__audioSupport.context;
        console.log("show \u5F53\u524DAudioContext\u72B6\u6001:", content.state);
        console.log("\u5F53\u524D\u6D4B\u8BD5\u97F3\u9891\u4FE1\u606F:", audio);
        // return;
        // 标记音频系统需要重置
        this.isAudioSystemReset = false;
        this.scheduleOnce(function () {
            content.resume();
            // this.rebuildAudioSystem();
            // this.scheduleOnce(() => {
            //     const id = cc.audioEngine.playEffect(this.audioClip, false);
            //     cc.audioEngine.setCurrentTime(id, 2);
            //     cc.audioEngine.setFinishCallback(id, () => {
            //         console.log("音频重新播放完成，ID:", id);
            //     });
            // }, 0.4)
            // 核心修复逻辑
            if (content.state === "suspended") {
                console.log("尝试恢复 suspended 状态");
                // 1. 强制断开音频节点连接（防止残留状态）
                if (audio === null || audio === void 0 ? void 0 : audio._sourceNode) {
                    audio._sourceNode.disconnect();
                    console.log("已断开旧音频节点连接");
                }
                // 2. 重新创建音频源（关键步骤）
                var newSource_1 = content.createBufferSource();
                console.log("创建新的音频源节点 newSource: ", newSource_1);
                console.log("设置音频源 buffer: ", audio._element._buffer);
                newSource_1.buffer = audio._element._buffer;
                console.log("设置音频源 _gainObj: ", audio._element._gainObj);
                newSource_1.connect(audio._element._gainObj);
                newSource_1.loop = audio._element._loop;
                audio._sourceNode = newSource_1;
                // 3. 恢复上下文并重启播放
                content.resume().then(function () {
                    console.log("AudioContext resumed，尝试重新播放");
                    // 4. 从上次位置开始播放
                    var currentTime = cc.audioEngine.getCurrentTime(_this._testAudioId);
                    newSource_1.start(0, currentTime);
                }).catch(function (e) {
                    console.error("恢复失败:", e);
                });
            }
            else {
                // 正常恢复流程
                content.resume();
            }
        }, 0.1);
    };
    AudioManager.prototype.handleGameHide = function () {
        console.log("应用进入后台");
        var state = cc.audioEngine.getState(this._testAudioId);
        console.log("\u5F53\u524D\u6D4B\u8BD5\u97F3\u9891ID=" + this._testAudioId + ", \u72B6\u6001=" + state);
        // this.savePlayingAudios();
    };
    // // 保存正在播放的音频状态
    // savePlayingAudios() {
    //     // 清空旧的记录
    //     this.playingAudios.clear();
    //     // 获取所有音频ID
    //     //@ts-ignore
    //     const allAudioIds = Object.keys(cc.audioEngine._id2audio);
    //     console.log(`检查 ${allAudioIds.length} 个音频状态`);
    //     for (const idStr of allAudioIds) {
    //         const id = parseInt(idStr);
    //         try {
    //             // 检查是否在播放
    //             const state = cc.audioEngine.getState(id);
    //             console.log(`音频ID=${id}, 状态=${state}`);
    //             if (state === cc.audioEngine.AudioState.PLAYING) {
    //                 //@ts-ignore
    //                 const audio = cc.audioEngine._id2audio[id];
    //                 if (!audio) continue;
    //                 // 获取音频信息
    //                 const currentTime = cc.audioEngine.getCurrentTime(id);
    //                 const volume = cc.audioEngine.getVolume(id);
    //                 const loop = cc.audioEngine.isLoop(id);
    //                 const clip = audio._src;
    //                 // 保存信息
    //                 this.playingAudios.set(id, {
    //                     clip,
    //                     loop,
    //                     volume,
    //                     currentTime
    //                 });
    //                 console.log(`保存音频状态: ID=${id}, 时间=${currentTime.toFixed(2)}, 循环=${loop}`);
    //             }
    //         } catch (e) {
    //             console.error(`获取音频 ${id} 状态失败:`, e);
    //         }
    //     }
    //     console.log(`共保存了 ${this.playingAudios.size} 个正在播放的音频状态`);
    // }
    // // 恢复之前播放的音频
    // restorePausedAudios() {
    //     if (this.playingAudios.size === 0) {
    //         console.log("没有需要恢复的音频");
    //         return;
    //     }
    //     console.log(`准备恢复 ${this.playingAudios.size} 个音频`);
    //     // 逐个恢复
    //     const newAudioIds = new Map();
    //     //@ts-ignore
    //     for (const [oldId, info] of this.playingAudios.entries()) {
    //         try {
    //             if (!info.clip) {
    //                 console.log(`音频 ${oldId} 没有可用的clip，跳过`);
    //                 continue;
    //             }
    //             console.log(`恢复音频: 原ID=${oldId}, 时间=${info.currentTime.toFixed(2)}`);
    //             // 重新播放
    //             const newId = cc.audioEngine.playEffect(info.clip, info.loop);
    //             cc.audioEngine.setVolume(newId, info.volume);
    //             // 记录新旧ID映射
    //             newAudioIds.set(oldId, newId);
    //             // 设置播放位置
    //             if (info.currentTime > 0) {
    //                 setTimeout(() => {
    //                     try {
    //                         cc.audioEngine.setCurrentTime(newId, info.currentTime);
    //                         console.log(`设置音频 ${newId} 的播放位置: ${info.currentTime.toFixed(2)}`);
    //                     } catch (e) {
    //                         console.error(`设置音频 ${newId} 播放位置失败:`, e);
    //                     }
    //                 }, 100);
    //             }
    //         } catch (e) {
    //             console.error(`恢复音频 ${oldId} 失败:`, e);
    //         }
    //     }
    //     console.log(`成功恢复了 ${newAudioIds.size} 个音频`);
    //     // 清空保存的状态
    //     this.playingAudios.clear();
    // }
    AudioManager.prototype.rebuildAudioSystem = function () {
        console.log("开始重建音频系统");
        try {
            // 1. 获取当前 AudioContext
            //@ts-ignore
            var oldContext = cc.sys.__audioSupport.context;
            if (oldContext) {
                console.log("当前 AudioContext 状态:", oldContext.state);
                // 2. 关闭旧的 AudioContext
                try {
                    if (oldContext.close) {
                        oldContext.close();
                        console.log("已关闭旧 AudioContext");
                    }
                }
                catch (e) {
                    console.error("关闭旧 AudioContext 失败:", e);
                }
            }
            // 3. 创建新的 AudioContext
            console.log("创建新的 AudioContext");
            var AudioContextClass = window.AudioContext;
            if (AudioContextClass) {
                //@ts-ignore
                cc.sys.__audioSupport.context = new AudioContext();
                //@ts-ignore
                console.log("新 AudioContext 创建成功，状态:", cc.sys.__audioSupport.context.state);
                // 标记系统已重置
                this.isAudioSystemReset = true;
                console.log("音频系统重建完成，下次播放应该正常");
            }
        }
        catch (e) {
            console.error("重建音频系统失败:", e);
        }
    };
    AudioManager.prototype.onPlayButtonClick = function () {
        console.log("播放按钮点击");
        // 检查音频系统是否需要重置
        this.playAudio();
    };
    AudioManager.prototype.playAudio = function () {
        var _this = this;
        try {
            var audioId_1 = cc.audioEngine.playEffect(this.audioClip, false);
            console.log("音频开始播放，ID:", audioId_1);
            if (audioId_1) {
                cc.audioEngine.setFinishCallback(audioId_1, function () {
                    console.log("音频播放完成，ID:", audioId_1);
                    _this._testAudioId = -1;
                });
                var duration = cc.audioEngine.getDuration(audioId_1);
                console.log("\u97F3\u9891ID=" + audioId_1 + "\uFF0C\u65F6\u957F=" + duration);
                this._testAudioId = audioId_1;
                // 设置检查播放状态的定时器
                this.scheduleOnce(function () {
                    try {
                        var state = cc.audioEngine.getState(audioId_1);
                        console.log("\u97F3\u9891" + audioId_1 + "\u72B6\u6001:", state);
                        if (state !== cc.audioEngine.AudioState.PLAYING) {
                            console.warn("音频可能没有正常播放");
                        }
                    }
                    catch (e) {
                        console.error("检查音频状态失败:", e);
                    }
                }, 0.2);
            }
            else {
                console.error("音频播放失败，无效的audioId");
            }
        }
        catch (e) {
            console.error("播放音频出错:", e);
            // 如果播放失败，尝试完全重建系统
            if (cc.sys.os === cc.sys.OS_IOS) {
                console.log("播放失败，尝试重建系统");
                this.rebuildAudioSystem();
            }
        }
    };
    AudioManager.prototype.onResume = function () {
        console.log("手动恢复按钮点击");
        // this.rebuildAudioSystem();
        var context = cc.sys.__audioSupport.context;
        var audio = cc.audioEngine._id2audio[this._testAudioId];
        if (context == audio._element._context) {
            console.log("当前音频上下文与全局一致，尝试恢复");
        }
        console.log("当前AudioContext状态:", context.state);
        if (audio._element._context.state === "interrupted") {
            console.log("音频系统中断，尝试恢复");
            audio._element._context.resume();
        }
        context.resume();
    };
    AudioManager.prototype.onReplay = function () {
        var id = cc.audioEngine.playEffect(this.audioClip, false);
        var onFinish = function () {
            console.log("音频播放完成，ID:", id);
        };
        cc.audioEngine.setFinishCallback(id, onFinish);
        cc.audioEngine.setCurrentTime(id, 2);
        // cc.audioEngine.setFinishCallback(id, onFinish);
        // this.scheduleOnce(() => {
        //     cc.audioEngine.setFinishCallback(id, () => {
        //         console.log("音频重新播放完成，ID:", id);
        //         this._testAudioId = -1;
        //     });
        // }, 0.2)
    };
    AudioManager.prototype.onDestroy = function () {
        cc.game.off(cc.game.EVENT_SHOW, this.handleGameShow, this);
        cc.game.off(cc.game.EVENT_HIDE, this.handleGameHide, this);
    };
    __decorate([
        property(cc.Button)
    ], AudioManager.prototype, "playButton", void 0);
    __decorate([
        property(cc.AudioClip)
    ], AudioManager.prototype, "audioClip", void 0);
    AudioManager = __decorate([
        ccclass
    ], AudioManager);
    return AudioManager;
}(cc.Component));
exports.default = AudioManager;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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