"use strict";
cc._RF.push(module, 'd1ea53aLRNMDrA5bw+9aNYa', 'Test');
// Script/Test.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var NewClass = /** @class */ (function (_super) {
    __extends(NewClass, _super);
    function NewClass() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._resumeAttempts = 0;
        _this._maxResumeAttempts = 3;
        _this._resumeTimer = null;
        _this.audioClip = null;
        return _this;
    }
    NewClass.prototype.onLoad = function () {
        // 使用捕获阶段监听pageshow事件，确保尽早处理
        window.addEventListener('pageshow', this.onPageShow.bind(this), true);
        // 使用自定义的展示事件处理函数
        cc.game.on(cc.game.EVENT_SHOW, this.onGameShow.bind(this));
        cc.game.on(cc.game.EVENT_HIDE, this.onGameHide.bind(this));
    };
    NewClass.prototype.onPageShow = function (event) {
        console.log("pageshow事件触发", event.persisted);
        if (event.persisted && cc.sys.os === cc.sys.OS_IOS) {
            // 清除之前可能存在的定时器
            this.clearResumeTimer();
            // 重置恢复尝试次数
            this._resumeAttempts = 0;
            // 立即尝试一次恢复
            this.onResume();
            // 设置多次尝试恢复的定时器
            this.scheduleResumeAttempts();
        }
    };
    NewClass.prototype.onGameShow = function () {
        console.log("Game.EVENT_SHOW");
        if (cc.sys.os === cc.sys.OS_IOS) {
            // 清除之前可能存在的定时器
            this.clearResumeTimer();
            // 重置恢复尝试次数
            this._resumeAttempts = 0;
            // 立即尝试一次恢复
            this.onResume();
            // 设置多次尝试恢复的定时器
            this.scheduleResumeAttempts();
        }
    };
    NewClass.prototype.onGameHide = function () {
        console.log("Game.EVENT_HIDE");
        // 清除恢复定时器
        this.clearResumeTimer();
    };
    NewClass.prototype.scheduleResumeAttempts = function () {
        var _this = this;
        // 设置多次尝试，间隔递增
        this._resumeTimer = setTimeout(function () {
            _this._resumeAttempts++;
            if (_this._resumeAttempts < _this._maxResumeAttempts) {
                console.log("\u7B2C" + _this._resumeAttempts + "\u6B21\u5C1D\u8BD5\u6062\u590DAudioContext");
                _this.onResume();
                _this.scheduleResumeAttempts();
            }
        }, 300 * (this._resumeAttempts + 1)); // 300ms, 600ms, 900ms递增间隔
    };
    NewClass.prototype.clearResumeTimer = function () {
        if (this._resumeTimer) {
            clearTimeout(this._resumeTimer);
            this._resumeTimer = null;
        }
    };
    NewClass.prototype.start = function () { };
    NewClass.prototype.onDestroy = function () {
        // 清除定时器
        this.clearResumeTimer();
        // 移除事件监听
        window.removeEventListener('pageshow', this.onPageShow.bind(this), true);
        cc.game.off(cc.game.EVENT_SHOW, this.onGameShow, this);
        cc.game.off(cc.game.EVENT_HIDE, this.onGameHide, this);
    };
    NewClass.prototype.play = function () {
        var _this = this;
        // 在播放前检查AudioContext状态
        if (cc.sys.os === cc.sys.OS_IOS) {
            var globalContext = cc.sys.__audioSupport.context;
            if (globalContext &&
                (globalContext.state === 'suspended' || globalContext.state === 'interrupted')) {
                console.log("播放前恢复AudioContext");
                globalContext.resume().then(function () {
                    _this.doPlay();
                }).catch(function (err) {
                    console.error("播放前恢复AudioContext失败:", err);
                    // 尝试强制恢复
                    _this.forceResumeAudioContext();
                    setTimeout(function () { return _this.doPlay(); }, 100);
                });
            }
            else {
                this.doPlay();
            }
        }
        else {
            this.doPlay();
        }
    };
    NewClass.prototype.doPlay = function () {
        var audioId = cc.audioEngine.playEffect(this.audioClip, false);
        console.log("audioId play:", audioId);
        if (audioId) {
            cc.audioEngine.setVolume(audioId, 1);
            cc.audioEngine.setEffectsVolume(1);
            cc.audioEngine.setFinishCallback(audioId, function () {
                console.log("audio play finish");
            });
        }
        else {
            console.error("音频播放失败，无效的audioId");
        }
    };
    NewClass.prototype.onResume = function () {
        var _this = this;
        var globalContext = cc.sys.__audioSupport.context;
        if (!globalContext) {
            console.warn("找不到全局AudioContext");
            return;
        }
        console.log("当前AudioContext状态:", globalContext.state);
        if (globalContext.state === 'suspended' || globalContext.state === 'interrupted') {
            console.log("恢复全局AudioContext");
            // 尝试恢复全局AudioContext
            globalContext.resume().then(function () {
                console.log("全局AudioContext恢复成功");
                // 强制"唤醒"音频系统
                _this.forceResumeAudioContext();
                // 恢复正在播放的音频
                _this.resumePlayingAudio();
            }).catch(function (err) {
                console.error("恢复AudioContext失败:", err);
                // 尝试使用更激进的方式恢复
                _this.forceResumeAudioContext();
            });
        }
        else {
            console.log("AudioContext状态已正常:", globalContext.state);
            // 即使状态看起来正常，也进行一次音频恢复
            // 有时iOS会报告状态正常但实际上还是无法播放
            this.resumePlayingAudio();
        }
    };
    NewClass.prototype.forceResumeAudioContext = function () {
        try {
            var globalContext = cc.sys.__audioSupport.context;
            if (!globalContext)
                return;
            // 创建一个短暂的空音频来"唤醒"系统
            var testOsc_1 = globalContext.createOscillator();
            var testGain_1 = globalContext.createGain();
            testGain_1.gain.value = 0.01; // 极小音量但不是0
            testOsc_1.connect(testGain_1);
            testGain_1.connect(globalContext.destination);
            testOsc_1.start(0);
            setTimeout(function () {
                try {
                    testOsc_1.stop();
                    testOsc_1.disconnect();
                    testGain_1.disconnect();
                }
                catch (e) { }
            }, 100); // 短暂播放100ms
            console.log("强制唤醒AudioContext完成");
        }
        catch (e) {
            console.error("强制唤醒AudioContext失败:", e);
        }
    };
    NewClass.prototype.resumePlayingAudio = function () {
        // 遍历所有音频并检查它们的状态
        var audioIds = Object.keys(cc.audioEngine._id2audio);
        console.log("恢复音频状态检查, 当前音频数:", audioIds.length);
        if (audioIds.length === 0)
            return;
        // 恢复所有正在播放的音频
        for (var _i = 0, audioIds_1 = audioIds; _i < audioIds_1.length; _i++) {
            var id = audioIds_1[_i];
            var audio = cc.audioEngine._id2audio[id];
            if (!audio || !audio._element)
                continue;
            var audioState = audio._state;
            console.log("\u97F3\u9891ID: " + id + ", \u72B6\u6001: " + audioState);
            if (audioState === cc.audioEngine.AudioState.PLAYING &&
                (audio._element.paused ||
                    (audio._element._currentSource === null && audio._element._context))) {
                console.log("\u6062\u590D\u64AD\u653E\u97F3\u9891: " + id);
                try {
                    // 先确保音量正确
                    var volume = audio.getVolume();
                    audio.setVolume(volume);
                    // 然后恢复播放
                    audio.resume();
                }
                catch (e) {
                    console.error("\u6062\u590D\u97F3\u9891" + id + "\u5931\u8D25:", e);
                }
            }
        }
    };
    __decorate([
        property(cc.AudioClip)
    ], NewClass.prototype, "audioClip", void 0);
    NewClass = __decorate([
        ccclass
    ], NewClass);
    return NewClass;
}(cc.Component));
exports.default = NewClass;

cc._RF.pop();