"use strict";
cc._RF.push(module, '364a0LTL+NObrYHvz2JIiVO', 'Test3');
// Script/Test3.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var AudioManager = /** @class */ (function (_super) {
    __extends(AudioManager, _super);
    function AudioManager() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.playButton = null;
        _this.audioClip = null;
        _this.tipAudioUI = null;
        // 保存正在播放的音频信息
        _this.playingAudios = new Array();
        _this._testAudioId = -1;
        return _this;
    }
    AudioManager.prototype.onLoad = function () {
        var _this = this;
        if (cc.sys.isBrowser && cc.sys.os === cc.sys.OS_IOS) {
            cc.game.on(cc.game.EVENT_GAME_INITED, function () {
                cc.game.on(cc.game.EVENT_SHOW, _this.handleGameShow, _this);
                cc.game.on(cc.game.EVENT_HIDE, _this.handleGameHide, _this);
            });
        }
    };
    AudioManager.prototype.handleGameShow = function () {
        var _this = this;
        console.log("应用恢复到前台");
        if (cc.sys.os === cc.sys.OS_IOS && cc.sys.isBrowser && cc.sys.isMobile) {
            //@ts-ignore
            var content_1 = cc.sys.__audioSupport.context;
            console.log("\u5F53\u524D\u97F3\u9891\u4E0A\u4E0B\u6587\u72B6\u6001: " + content_1.state);
            if (content_1.state === "suspended") {
                //挂起状态，高版本ios系统, 需要重建 audioContent, 启用并关闭旧的
                this.savePlayingAudios();
                this.rebuildAudioSystem().then(function () {
                    //展示恢复音频界面，提示用户触摸屏幕恢复音频播放
                    _this._showTipAudioUI();
                });
            }
            else {
                // 需要延迟一小会儿
                console.log("普通恢复");
                setTimeout(function () {
                    content_1.resume();
                }, 50);
            }
        }
    };
    AudioManager.prototype.handleGameHide = function () {
        console.log("应用进入后台");
        var state = cc.audioEngine.getState(this._testAudioId);
        console.log("\u5F53\u524D\u6D4B\u8BD5\u97F3\u9891ID=" + this._testAudioId + ", \u72B6\u6001=" + state);
        // this.savePlayingAudios();
    };
    AudioManager.prototype.savePlayingAudios = function () {
        this.playingAudios.length = 0; // 清空旧的记录
        //@ts-ignore
        var allAudioIds = Object.keys(cc.audioEngine._id2audio);
        console.log("\u68C0\u67E5 " + allAudioIds.length + " \u4E2A\u97F3\u9891\u72B6\u6001");
        for (var _i = 0, allAudioIds_1 = allAudioIds; _i < allAudioIds_1.length; _i++) {
            var idStr = allAudioIds_1[_i];
            var id = parseInt(idStr);
            var state = cc.audioEngine.getState(id);
            if (state === cc.audioEngine.AudioState.PLAYING) {
                //@ts-ignore
                var audio = cc.audioEngine._id2audio[id];
                // 获取音频信息
                this.playingAudios.push({
                    id: id,
                    clip: audio._src,
                    loop: audio._element._loop,
                    volume: audio._element._volume,
                    currentTime: audio._element.currentTime,
                    finishCallback: audio._finishCallback
                });
            }
        }
        for (var _a = 0, _b = this.playingAudios; _a < _b.length; _a++) {
            var audioInfo = _b[_a];
            console.log("\u4FDD\u5B58\u97F3\u9891\u72B6\u6001: ID=" + audioInfo.id + ", \u65F6\u95F4=" + audioInfo.currentTime + ", \u5FAA\u73AF=" + audioInfo.loop + ", \u97F3\u91CF=" + audioInfo.volume + ", \u56DE\u8C03=" + (audioInfo.finishCallback ? '有' : '无'));
        }
    };
    // 恢复之前播放的音频
    AudioManager.prototype.restorePausedAudios = function () {
        if (this.playingAudios.length === 0) {
            console.log("没有需要恢复的音频");
            return;
        }
        console.log("\u51C6\u5907\u6062\u590D " + this.playingAudios.length + " \u4E2A\u97F3\u9891");
        for (var _i = 0, _a = this.playingAudios; _i < _a.length; _i++) {
            var audioInfo = _a[_i];
            console.log("\u6062\u590D\u97F3\u9891\u72B6\u6001: ID=" + audioInfo.id + ", \u65F6\u95F4=" + audioInfo.currentTime + ", \u5FAA\u73AF=" + audioInfo.loop + ", \u97F3\u91CF=" + audioInfo.volume + ", \u56DE\u8C03=" + (audioInfo.finishCallback ? '有' : '无'));
            if (!audioInfo.clip) {
                console.log("\u97F3\u9891\u6CA1\u6709\u53EF\u7528\u7684clip, \u8DF3\u8FC7");
                continue;
            }
            // 重新播放
            var newId = cc.audioEngine.play(audioInfo.clip, audioInfo.loop, audioInfo.volume);
            if (audioInfo.currentTime > 0) {
                cc.audioEngine.setCurrentTime(newId, audioInfo.currentTime);
            }
            if (audioInfo.finishCallback) {
                cc.audioEngine.setFinishCallback(newId, audioInfo.finishCallback);
            }
        }
        this.playingAudios.length = 0;
    };
    AudioManager.prototype.rebuildAudioSystem = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                console.log("开始重建音频系统");
                return [2 /*return*/, new Promise(function (resolve, reject) {
                        // 需要延迟一下
                        setTimeout(function () {
                            try {
                                //@ts-ignore
                                var oldContext = cc.sys.__audioSupport.context;
                                if (oldContext && oldContext.close) {
                                    oldContext.close();
                                    console.log("已关闭旧 AudioContext");
                                }
                                // 3. 创建新的 AudioContext
                                console.log("创建新的 AudioContext");
                                var AudioContextClass = window.AudioContext;
                                if (AudioContextClass) {
                                    //@ts-ignore
                                    var audioSupport_1 = cc.sys.__audioSupport;
                                    //一下摘自引擎源码的创建方式
                                    if (audioSupport_1.WEB_AUDIO) {
                                        //@ts-ignore
                                        audioSupport_1.context = new (window.AudioContext || window.webkitAudioContext || window.mozAudioContext)();
                                        if (audioSupport_1.DELAY_CREATE_CTX) {
                                            //@ts-ignore
                                            setTimeout(function () { audioSupport_1.context = new (window.AudioContext || window.webkitAudioContext || window.mozAudioContext)(); }, 0);
                                        }
                                    }
                                    //@ts-ignore
                                    console.log("新 AudioContext 创建成功，状态:", cc.sys.__audioSupport.context.state);
                                }
                                resolve(true);
                            }
                            catch (e) {
                                console.error("重建音频系统失败:", e);
                                reject(e);
                            }
                        }, 50);
                    })];
            });
        });
    };
    AudioManager.prototype.onPlayButtonClick = function () {
        console.log("播放按钮点击");
        // 检查音频系统是否需要重置
        this.playAudio();
    };
    AudioManager.prototype.playAudio = function () {
        var audioId = cc.audioEngine.playEffect(this.audioClip, false);
        cc.audioEngine.setFinishCallback(audioId, function () {
            console.log("音频播放完成，ID:", audioId);
        });
    };
    AudioManager.prototype._showTipAudioUI = function () {
        var _this = this;
        var scene = cc.director.getScene();
        var canvas = scene.getChildByName("Canvas");
        var tipAudioUI = cc.instantiate(this.tipAudioUI);
        tipAudioUI.parent = canvas;
        tipAudioUI.setPosition(0, 0);
        tipAudioUI.on(cc.Node.EventType.TOUCH_START, function () {
            _this.restorePausedAudios();
            tipAudioUI.destroy();
        });
    };
    AudioManager.prototype.onResume = function () {
        console.log("手动恢复按钮点击");
        // this.rebuildAudioSystem();
        this.restorePausedAudios();
    };
    AudioManager.prototype.onReplay = function () {
        var id = cc.audioEngine.playEffect(this.audioClip, false);
        var onFinish = function () {
            console.log("音频播放完成，ID:", id);
        };
        cc.audioEngine.setFinishCallback(id, onFinish);
        cc.audioEngine.setCurrentTime(id, 2);
        // cc.audioEngine.setFinishCallback(id, onFinish);
        // this.scheduleOnce(() => {
        //     cc.audioEngine.setFinishCallback(id, () => {
        //         console.log("音频重新播放完成，ID:", id);
        //         this._testAudioId = -1;
        //     });
        // }, 0.2)
    };
    AudioManager.prototype.onDestroy = function () {
        cc.game.off(cc.game.EVENT_SHOW, this.handleGameShow, this);
        cc.game.off(cc.game.EVENT_HIDE, this.handleGameHide, this);
    };
    __decorate([
        property(cc.Button)
    ], AudioManager.prototype, "playButton", void 0);
    __decorate([
        property(cc.AudioClip)
    ], AudioManager.prototype, "audioClip", void 0);
    __decorate([
        property(cc.Prefab)
    ], AudioManager.prototype, "tipAudioUI", void 0);
    AudioManager = __decorate([
        ccclass
    ], AudioManager);
    return AudioManager;
}(cc.Component));
exports.default = AudioManager;

cc._RF.pop();